LIBRARY IEEE; 
USE IEEE.std_logic_1164.ALL;
ENTITY and2 IS
  GENERIC ( a_ipd, b_ipd, c_opd : TIME );
  PORT ( a, b : IN std_logic;
         c: OUT std_logic);
END and2;

ARCHITECTURE int_signals OF and2 IS
  SIGNAL inta, intb : std_logic;
BEGIN
  inta <= TRANSPORT a AFTER a_ipd;
  intb <=TRANSPORT b AFTER b_ipd;

  c <= inta AND intb AFTER c_opd;
END int_signals;

ARCHITECTURE attr OF and2 IS
BEGIN
  c <= a'DELAYED(a_ipd) AND b'DELAYED(b_ipd) AFTER c_opd; 
END attr;

